# Introduction to Uncertainty Quantification

## General Code Requirements

[Python](https://python.org/) is a popular language for scientific computing, and a frequent choice for machine learning as well. 

## Instructions for this Lab

1. create a `venv` by `python -m venv py312 --upgrade-deps` (e.g. for python `3.12`)
2. setup that `venv` by doing `source py312/bin/activate`
3. (optional) install `uv` for faster installations (see [uv docs](https://github.com/astral-sh/uv))
4. either do `uv pip install -r ./requirements.txt` or plain `python -m pip install -r ./requirements.txt`

If you like to train cpu-only, you can install torch without CUDA support. This is best beformed between step 2 and 4 in the recipe above by running:
```shell
uv pip install --extra-index-url https://download.pytorch.org/whl/cpu torch
```
or without `uv`:
```shell
python -m pip install --extra-index-url https://download.pytorch.org/whl/cpu torch
```

After this, you should be able to open the notebook and run it with `jupyter`.

```
$ jupyter nbclassic decision_trees_with_peanuts.ipynb
```

> If you have an old'ish version of `jupyter` installed, do:
> ```
> $ jupyter notebook decision_trees_with_peanuts.ipynb
> ```
> 

**Note**: The `jupyter` ecosystem is not included in the requirements file. Should you get errors when calling `jupyter`, it has to be installed by issueing `python -m pip install jupyter`. 
